package gov.va.genisis2.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

import org.hibernate.annotations.CreationTimestamp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * The Class CommentHistory.
 * 
 * Description: In this CommentHistory Class implements the interface Serializable
 * and defines the entity and data mapping for the dbo.User_Approver Table in
 * the database.
 */
@Entity
@Table(name = "CommentHistory", schema = "dbo")
@JsonIgnoreProperties({ "request", "workflowStatus", "commentId", "taskId" })
public class CommentHistory implements java.io.Serializable {

	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = -1794346067929332768L;

	/** The comment id. */
	private int commentId;
	
	/** The request. */
	private Request request;
	
	/** The workflow status. */
	private WorkflowStatus workflowStatus;
	
	/** The comments. */
	private String comments;
	
	/** The created on. */
	private Date createdOn;
	
	/** The created by. */
	private String createdBy;
	
	/** The request id. */
	private int requestId;
	
	/** The status. */
	private String status;
	
	/** The type. */
	private String type;
	
	/** The task id. */
	private String taskId;

	/**
	 * Instantiates a new comment history.
	 */
	public CommentHistory() {
		// Do nothing. The method is an intentionally-blank override.
	}

	/**
	 * Instantiates a new comment history.
	 *
	 * @param commentId the comment id
	 * @param request the request
	 * @param workflowStatus the workflow status
	 */
	public CommentHistory(int commentId, Request request, WorkflowStatus workflowStatus) {
		this.commentId = commentId;
		this.request = request;
		this.workflowStatus = workflowStatus;
	}

	/**
	 * Instantiates a new comment history.
	 *
	 * @param commentId the comment id
	 * @param request the request
	 * @param workflowStatus the workflow status
	 * @param comments the comments
	 * @param createdOn the created on
	 * @param createdBy the created by
	 * @param taskId the task id
	 */
	public CommentHistory(int commentId, Request request, WorkflowStatus workflowStatus, String comments,
			Date createdOn, String createdBy, String taskId) {
		this.commentId = commentId;
		this.request = request;
		this.workflowStatus = workflowStatus;
		this.comments = comments;
		this.createdOn = createdOn;
		this.createdBy = createdBy;
		this.taskId = taskId;
	}

	/**
	 * Gets the comment id.
	 *
	 * @return the comment id
	 */
	@Id
	@Column(name = "CommentId", unique = true, nullable = false)
	public int getCommentId() {
		return this.commentId;
	}

	/**
	 * Sets the comment id.
	 *
	 * @param commentId the new comment id
	 */
	public void setCommentId(int commentId) {
		this.commentId = commentId;
	}

	/**
	 * Gets the request.
	 *
	 * @return the request
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "RequestId", nullable = false)
	public Request getRequest() {
		return this.request;
	}

	/**
	 * Sets the request.
	 *
	 * @param request the new request
	 */
	public void setRequest(Request request) {
		this.request = request;
	}

	/**
	 * Gets the workflow status.
	 *
	 * @return the workflow status
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "StatusId", nullable = false)
	public WorkflowStatus getWorkflowStatus() {
		return this.workflowStatus;
	}

	/**
	 * Sets the workflow status.
	 *
	 * @param workflowStatus the new workflow status
	 */
	public void setWorkflowStatus(WorkflowStatus workflowStatus) {
		this.workflowStatus = workflowStatus;
	}

	/**
	 * Gets the comments.
	 *
	 * @return the comments
	 */
	@Column(name = "Comments", length = 3000)
	public String getComments() {
		return this.comments;
	}

	/**
	 * Sets the comments.
	 *
	 * @param comment the new comments
	 */
	public void setComments(String comment) {
		this.comments = comment;
	}

	/**
	 * Gets the created on.
	 *
	 * @return the created on
	 */
	@CreationTimestamp
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "CreatedOn", length = 23)
	public Date getCreatedOn() {
		return this.createdOn;
	}

	/**
	 * Sets the created on.
	 *
	 * @param createdOn the new created on
	 */
	public void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}

	/**
	 * Gets the created by.
	 *
	 * @return the created by
	 */
	@Column(name = "CreatedBy", length = 50)
	public String getCreatedBy() {
		return this.createdBy;
	}

	/**
	 * Sets the created by.
	 *
	 * @param createdBy the new created by
	 */
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	/**
	 * Gets the request id.
	 *
	 * @return the request id
	 */
	@Transient
	public int getRequestId() {
		return requestId;
	}

	/**
	 * Sets the request id.
	 *
	 * @param requestId the new request id
	 */
	public void setRequestId(int requestId) {
		this.requestId = requestId;
	}

	/**
	 * Gets the status.
	 *
	 * @return the status
	 */
	@Transient
	public String getStatus() {
		return status;
	}

	/**
	 * Sets the status.
	 *
	 * @param status the new status
	 */
	public void setStatus(String status) {
		this.status = status;
	}

	/**
	 * Gets the type.
	 *
	 * @return the type
	 */
	@Column(name = "Type", length = 6)
	public String getType() {
		return type;
	}

	/**
	 * Sets the type.
	 *
	 * @param type the new type
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * Gets the task id.
	 *
	 * @return the task id
	 */
	@Column(name = "TaskId", length = 50)
	public String getTaskId() {
		return this.taskId;
	}

	/**
	 * Sets the task id.
	 *
	 * @param taskId the new task id
	 */
	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "CommentHistory [commentId=" + commentId + ", request=" + request + ", workflowStatus=" + workflowStatus
				+ ", comments=" + comments + ", createdOn=" + createdOn + ", createdBy=" + createdBy + ", requestId="
				+ requestId + ", status=" + status + ", type=" + type + ", taskId=" + taskId + "]";
	}

}
